$(document).ready(function() {
					
	var clipboard = new ClipboardJS('.btn-copy-link');
	
	clipboard.on('success', function(e) {
	    
	    $(e.trigger).html("Copied!").addClass("disabled");
	    
	    setTimeout(function() {
		    $(e.trigger).html("<i class='fas fa-copy'></i> Copy Quiz Link").removeClass("disabled");
	    }, 2000);
	
	    e.clearSelection();
	});
	
	$(".menu-item").click(function(e) {
		
		e.preventDefault();
		
		window.location = $(this).attr("data-url");
		
	});
	
	$('.menu-select-mob').change(function() {
	    var menu_page = $(this).val();
	    
	    if(menu_page != "0") {
		    window.location = menu_page;
	    }
	});
					
	$(".btn-delete").click(function(e) {

		e.preventDefault();
		
		var quiz_id = $(this).attr("data-id");
		
		var r = confirm("Are you sure that you want to delete this quiz?");
		if (r == true) {
									
			$.ajax({
				url: "ajax/delete-user-quiz.php",
				type: 'POST',
		        data: {
			        quiz_id: quiz_id
		        },
		        dataType: "json",
		        success: function (data) {
			        
			        if(data.status == 0) {
				        showError(data.error);
			        } else {
				        
				        $(".quiz-line[data-id=" + quiz_id + "]").remove();
			
						// Check if we have more lines or not
						if (!$(".quiz-line")[0]){
							
							$(".table-quizzes").hide();
							$(".quiz_list_container").html('<div class="alert alert-danger alert-center">You didn\'t create any quiz yet <i class="em em-anguished"></i></div>');
							
						}
				        
			        }
			        
			    }
			});
			
		}
		
	});
	
	function showError(msg) {
		$.toast({
			text: msg,
			bgColor : '#e74c3c',
			textColor : '#fff', 
			position : 'top-right'
		});
	}
	
});